/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world.features;

import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.betterx.bclib.api.v2.levelgen.features.features.DefaultFeature;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.world.NetherBiomeBuilder;
import org.betterx.betternether.world.features.NetherThreadDataStorage;
import org.betterx.betternether.world.structures.StructureGeneratorThreadContext;

public class CleanupFeature
extends DefaultFeature {
    private static final BlockPos rel(BlockPos pos, int x, int y, int z) {
        return new BlockPos(pos.m_123341_() + x, pos.m_123342_() + y, pos.m_123343_() + z);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> featurePlaceContext) {
        BlockPos down;
        BlockPos up;
        if (!NetherBiomeBuilder.useLegacyGeneration) {
            return false;
        }
        StructureGeneratorThreadContext ctx = NetherThreadDataStorage.generatorForThread().context;
        int MAX_HEIGHT = featurePlaceContext.m_159775_().m_6331_();
        BlockPos.MutableBlockPos popPos = ctx.POS;
        BlockPos worldPos = featurePlaceContext.m_159777_();
        WorldGenLevel level = featurePlaceContext.m_159774_();
        int sx = worldPos.m_123341_() >> 4 << 4;
        int sz = worldPos.m_123343_() >> 4 << 4;
        Set<BlockPos> pos = ctx.BLOCKS;
        pos.clear();
        for (int y = 32; y < MAX_HEIGHT - 18; ++y) {
            popPos.m_142448_(y);
            for (int x = 0; x < 16; ++x) {
                popPos.m_142451_(x | sx);
                for (int z = 0; z < 16; ++z) {
                    popPos.m_142443_(z | sz);
                    if (!CleanupFeature.canReplace(level, (BlockPos)popPos)) continue;
                    up = popPos.m_7494_();
                    down = popPos.m_7495_();
                    BlockPos north = popPos.m_122012_();
                    BlockPos south = popPos.m_122019_();
                    BlockPos east = popPos.m_122029_();
                    BlockPos west = popPos.m_122024_();
                    if (level.m_46859_(north) && level.m_46859_(south)) {
                        pos.add(new BlockPos((Vec3i)popPos));
                        continue;
                    }
                    if (level.m_46859_(east) && level.m_46859_(west)) {
                        pos.add(new BlockPos((Vec3i)popPos));
                        continue;
                    }
                    if (level.m_46859_(up) && level.m_46859_(down)) {
                        pos.add(new BlockPos((Vec3i)popPos));
                        continue;
                    }
                    if (level.m_46859_(CleanupFeature.rel((BlockPos)popPos, 1, -1, -1)) && level.m_46859_(CleanupFeature.rel((BlockPos)popPos, -1, 1, 1))) {
                        pos.add(new BlockPos((Vec3i)popPos));
                        continue;
                    }
                    if (level.m_46859_(CleanupFeature.rel((BlockPos)popPos, 1, -1, 1)) && level.m_46859_(CleanupFeature.rel((BlockPos)popPos, -1, 1, -1))) {
                        pos.add(new BlockPos((Vec3i)popPos));
                        continue;
                    }
                    if (level.m_46859_(CleanupFeature.rel((BlockPos)popPos, -1, -1, -1)) && level.m_46859_(CleanupFeature.rel((BlockPos)popPos, 1, 1, 1))) {
                        pos.add(new BlockPos((Vec3i)popPos));
                        continue;
                    }
                    if (!level.m_46859_(CleanupFeature.rel((BlockPos)popPos, -1, -1, 1)) || !level.m_46859_(CleanupFeature.rel((BlockPos)popPos, 1, 1, -1))) continue;
                    pos.add(new BlockPos((Vec3i)popPos));
                }
            }
        }
        for (BlockPos p : pos) {
            BlocksHelper.setWithoutUpdate((LevelAccessor)level, p, AIR);
            up = p.m_7494_();
            BlockState state = level.m_8055_(up);
            if (!state.m_60734_().m_7898_(state, (LevelReader)level, up)) {
                BlocksHelper.setWithoutUpdate((LevelAccessor)level, up, AIR);
            }
            down = p.m_7495_();
            state = level.m_8055_(p);
            if (!level.m_8055_(down).m_60713_(Blocks.f_50134_) || !BlocksHelper.isNetherGround(state)) continue;
            BlocksHelper.setWithoutUpdate((LevelAccessor)level, down, state);
        }
        pos.clear();
        return true;
    }

    private static boolean canReplace(WorldGenLevel world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        return BlocksHelper.isNetherGround(state) || state.m_60734_() == Blocks.f_49994_;
    }
}

